////////////////////////////////////////////////////////////////////////////////
// Wonderswan emulator
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
// 07.04.2002: speed problems partially fixed
// 13.04.2002: Set cycles by line to 256 (according to toshi)
//			   this seems to work well in most situations with
//			   the new nec v30 cpu core
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include "../inc/rom.h"
#include "../inc/nec.h"
#include "../inc/necintrf.h"
#include "../inc/gpu.h"
#include "../inc/io.h"
#include "../inc/ws.h"

#include "../inc/audio.h"

int ws_skip = 0;

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////

#define FRAME_CYCLES 755
#define IO_ROM_BANK_BASE_SELECTOR	0xC0

UINT16	ws_rom_checksum;

char  WsHomeDir[1024];
char  WsRomDir[1024];
char  WsSramDir[1024];
char  WsSaveDir[1024];
char  WsShotDir[1024];
char  BaseName[256];
char  *ws_rom_path = NULL;
char  ws_rom_path_array[1024];
int   app_new_rom = 0;
int   app_gameRunning = 0;
int   DrawFilter = FILTER_NORMAL;
int   DrawSize = DS_1;
int   DrawFull = 0;
int   DrawMode = 0;
int   OldMode = 0;
UINT8  OldPort15 = 0xFF;
int   LCDSegment = 0;
int   ws_colourScheme = COLOUR_SCHEME_DEFAULT;
int   ws_system = WS_SYSTEM_COLOR;
//DWORD  *backbuffer = (DWORD*)malloc(224*144*sizeof(DWORD));
int   StatusWait = 0;

UINT8 *ws_rom;
DWORD romSize;
DWORD romAddressMask;
UINT8 *ws_staticRam;
DWORD sramSize;
DWORD sramAddressMask;
UINT8 *externalEeprom;
DWORD externalEepromSize;
DWORD externalEepromAddressMask;
UINT8 *internalRam;
UINT8 *internalEeprom;

DWORD ws_cycles=256/4;
DWORD ws_cyclesByLine=256/4;
DWORD vblank_count=0;
UINT16 hblank_timer=0;
UINT16 hblank_timer_preset=0;
UINT16 vblank_timer=0;
UINT16 vblank_timer_preset=0;
DWORD *sprite_table;
UINT8 sprite_count=0;


////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_patchRom(void)
{
	UINT8	*rom=memory_getRom();
	UINT32	romSize=memory_getRomSize();

	//s2d::Log::Output("developper Id: 0x%.2x\nGame Id: 0x%.2x\n",rom[romSize-10],rom[romSize-8]);

	if((rom[romSize-10]==0x01)&&(rom[romSize-8]==0x27)) // Detective Conan 
	{
		// WS cpu is using cache/pipeline or
		//   there's protected ROM bank where 
		//   pointing CS 
		
		rom[0xfffe8]=0xea;
		rom[0xfffe9]=0x00;
		rom[0xfffea]=0x00;
		rom[0xfffeb]=0x00;
		rom[0xfffec]=0x20;
		
	}
	ws_cyclesByLine=256;
}

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
int ws_init(char *rompath)
{
	UINT8	*rom;
	UINT32	romSize;

	if ((rom=ws_rom_load(rompath,&romSize))==NULL)
	{
		//s2d::Log::Output("Error: cannot load %s\n",rompath);
		return(0);
	}
	
	if (rompath[s2d::strlen((s2d::Char8*)rompath)-1]=='c')
		ws_gpu_operatingInColor=1;
	else
		ws_gpu_operatingInColor=0;


	ws_memory_init(rom,romSize);
	ws_patchRom();
	ws_io_init();
	ws_audio_init();
	ws_gpu_init();
	//if (ws_rotated())
	//	ws_io_flipControls();
	return(1);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_reset(void)
{
	ws_memory_reset();
	ws_io_reset();
	ws_audio_reset();
	ws_gpu_reset();
	nec_reset(NULL);
	nec_set_reg(NEC_SP,0x2000);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
int ws_executeLine(INT16 *framebuffer, int renderLine)
{
	int drawWholeScreen=0;
 
	//ws_audio_process();

	// update scanline register
	ws_ioRam[2]=ws_gpu_scanline;

	ws_cycles=nec_execute((ws_cyclesByLine>>1)+(rand()&7));
	ws_cycles+=nec_execute((ws_cyclesByLine>>1)+(rand()&7));

	if(ws_cycles>=ws_cyclesByLine+ws_cyclesByLine)
		ws_skip=ws_cycles/ws_cyclesByLine;
	else
		ws_skip=3;

	ws_cycles%=ws_cyclesByLine;

	for(UINT32 uI=0;uI<ws_skip;uI++)
	{
	   if (renderLine)
		   ws_gpu_renderScanline(framebuffer);

	   ws_gpu_scanline++;
	   if(ws_gpu_scanline==144)
		   drawWholeScreen=1;

	}
	if(ws_gpu_scanline>158)
	{
		ws_gpu_scanline=0;
		{
			if((ws_ioRam[0xb2]&32))/*VBLANK END INT*/ 
			{
				if(ws_ioRam[0xa7]!=0x35)/*Beatmania Fix*/
				{
					ws_ioRam[0xb6]&=~32;
					nec_int((ws_ioRam[0xb0]+5)*4);
				}
			}
		}
	}
	ws_ioRam[2]=ws_gpu_scanline;
	if(drawWholeScreen)
	{
	
		if(ws_ioRam[0xb2]&64) /*VBLANK INT*/
		{
			ws_ioRam[0xb6]&=~64;
			nec_int((ws_ioRam[0xb0]+6)*4);
		}
	}
   if(ws_ioRam[0xa4]&&(ws_ioRam[0xb2]&128)) /*HBLANK INT*/
   {
	  
	  if(!ws_ioRam[0xa5])
		  ws_ioRam[0xa5]=ws_ioRam[0xa4];
	  if(ws_ioRam[0xa5]) 
		  ws_ioRam[0xa5]--;
	  if((!ws_ioRam[0xa5])&&(ws_ioRam[0xb2]&128))
	  {
	
		  ws_ioRam[0xb6]&=~128;
		  nec_int((ws_ioRam[0xb0]+7)*4);

	  }
  }
  if((ws_ioRam[0x2]==ws_ioRam[0x3])&&(ws_ioRam[0xb2]&16)) /*SCANLINE INT*/
  {	
		ws_ioRam[0xb6]&=~16;
		nec_int((ws_ioRam[0xb0]+4)*4);
  }	 

  return(drawWholeScreen);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_done(void)
{
	ws_memory_done();
	ws_io_done();
	ws_audio_done();
	ws_gpu_done();
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void	ws_set_colour_scheme(int scheme)
{
	ws_gpu_set_colour_scheme(scheme);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void	ws_set_system(int system)
{
	if (system==WS_SYSTEM_COLOR)
		ws_gpu_forceColorSystem();
	else
	if (system==WS_SYSTEM_MONO)
		ws_gpu_forceMonoSystem();
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
#define MacroLoadNecRegisterFromFile(F,R)        \
		read(fp,&value,sizeof(value));		\
	    nec_set_reg(R,value); 

int	ws_loadState(char *statepath)
{
	//s2d::Log::Output("loading %s\n",statepath);
	UINT16	crc=memory_getRomCrc();
	UINT16	newCrc;
	unsigned	value;
	UINT8	ws_newVideoMode;

	//int fp=open(statepath,O_BINARY|O_RDONLY);
	FILE* m_fp = fopen( statepath, _LS("rb") );
	if(m_fp == NULL){
		return(0);
	}

	//if (fp==NULL)
	//	return(0);

	//read(fp,&newCrc,2);
	//if (newCrc!=crc)
	//{
	//	return(-1);
	//}
	// read file to memory
	fseek( m_fp, 0, SEEK_END );
	s32 size =  ftell(m_fp);

	s32* mem = (s32*)  malloc( size );
	s32* pstar = mem;

	fseek(m_fp, 0, SEEK_SET );
	fread( mem, size,m_fp );
	fclose(m_fp);

	//MacroLoadNecRegisterFromFile(fp,NEC_IP);
	//MacroLoadNecRegisterFromFile(fp,NEC_AW);
	//MacroLoadNecRegisterFromFile(fp,NEC_BW);
	//MacroLoadNecRegisterFromFile(fp,NEC_CW);
	//MacroLoadNecRegisterFromFile(fp,NEC_DW);
	//MacroLoadNecRegisterFromFile(fp,NEC_CS);
	//MacroLoadNecRegisterFromFile(fp,NEC_DS);
	//MacroLoadNecRegisterFromFile(fp,NEC_ES);
	//MacroLoadNecRegisterFromFile(fp,NEC_SS);
	//MacroLoadNecRegisterFromFile(fp,NEC_IX);
	//MacroLoadNecRegisterFromFile(fp,NEC_IY);
	//MacroLoadNecRegisterFromFile(fp,NEC_BP);
	//MacroLoadNecRegisterFromFile(fp,NEC_SP);
	//MacroLoadNecRegisterFromFile(fp,NEC_FLAGS);
	//MacroLoadNecRegisterFromFile(fp,NEC_VECTOR);
	//MacroLoadNecRegisterFromFile(fp,NEC_PENDING);
	//MacroLoadNecRegisterFromFile(fp,NEC_NMI_STATE);
	//MacroLoadNecRegisterFromFile(fp,NEC_IRQ_STATE);
	//
	//read(fp,internalRam,65536);
	//read(fp,ws_staticRam,65536);
	//read(fp,ws_ioRam,256);
	//read(fp,ws_paletteColors,8);
	//read(fp,ws_palette,16*4*2);
	//read(fp,wsc_palette,16*16*2);
	//read(fp,&ws_newVideoMode,1);
	//read(fp,&ws_gpu_scanline,1);
	//read(fp,externalEeprom,131072);	
	//ws_audio_readState(fp);
	//close(fp);
	
	// force a video mode change to make all tiles dirty
	ws_gpu_clearCache();
	return(1);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
#define MacroStoreNecRegisterToFile(F,R)        \
	    value=nec_get_reg(R); \
		write(fp,&value,sizeof(value));

int	ws_saveState(char *statepath)
{
	//UINT16	crc=memory_getRomCrc();
	//unsigned	value;
	//char	*newPath;
	//
	//newPath=new char[1024];
	////if (strlen(statepath)<4)
	////	sprintf(newPath,"%s.wss",statepath);
	////else
	////{
	////	int len=strlen(statepath);
	////	if ((statepath[len-1]!='s')&&(statepath[len-1]!='S'))
	////		sprintf(newPath,"%s.wss",statepath);
	////	else
	////	if ((statepath[len-2]!='s')&&(statepath[len-2]!='S'))
	////		sprintf(newPath,"%s.wss",statepath);
	////	else
	////	if ((statepath[len-3]!='w')&&(statepath[len-3]!='w'))
	////		sprintf(newPath,"%s.wss",statepath);
	////	else
	////	if (statepath[len-4]!='.')
	////		sprintf(newPath,"%s.wss",statepath);
	////	else
	////		sprintf(newPath,"%s",statepath);
	////}
	//int	fp=open(newPath,O_BINARY|O_RDWR|O_CREAT);
	//delete newPath;
	//if (fp==-1)
	//	return(0);
	//write(fp,&crc,2);
	//MacroStoreNecRegisterToFile(fp,NEC_IP);
	//MacroStoreNecRegisterToFile(fp,NEC_AW);
	//MacroStoreNecRegisterToFile(fp,NEC_BW);
	//MacroStoreNecRegisterToFile(fp,NEC_CW);
	//MacroStoreNecRegisterToFile(fp,NEC_DW);
	//MacroStoreNecRegisterToFile(fp,NEC_CS);
	//MacroStoreNecRegisterToFile(fp,NEC_DS);
	//MacroStoreNecRegisterToFile(fp,NEC_ES);
	//MacroStoreNecRegisterToFile(fp,NEC_SS);
	//MacroStoreNecRegisterToFile(fp,NEC_IX);
	//MacroStoreNecRegisterToFile(fp,NEC_IY);
	//MacroStoreNecRegisterToFile(fp,NEC_BP);
	//MacroStoreNecRegisterToFile(fp,NEC_SP);
	//MacroStoreNecRegisterToFile(fp,NEC_FLAGS);
	//MacroStoreNecRegisterToFile(fp,NEC_VECTOR);
	//MacroStoreNecRegisterToFile(fp,NEC_PENDING);
	//MacroStoreNecRegisterToFile(fp,NEC_NMI_STATE);
	//MacroStoreNecRegisterToFile(fp,NEC_IRQ_STATE);

	//write(fp,internalRam,65536);
	//write(fp,ws_staticRam,65536);
	//write(fp,ws_ioRam,256);
	//write(fp,ws_paletteColors,8);
	//write(fp,ws_palette,16*4*2);
	//write(fp,wsc_palette,16*16*2);
	//write(fp,&ws_videoMode,1);
	//write(fp,&ws_gpu_scanline,1);
	//write(fp,externalEeprom,131072);	
	//ws_audio_writeState(fp);
	//close(fp);

	FILE* m_fp = fopen( statepath, _LS("wb+") );

	if(m_fp == NULL){
		return(0);
	}
	
	//fwrite(&Scene, sizeof(s32),m_fp );

	// close file
	fclose(m_fp);

	return(1);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
int ws_rotated(void)
{
	UINT8	*rom=memory_getRom();
	UINT32	romSize=memory_getRomSize();
	
	return(rom[romSize-4]&1);
}

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_memory_init(UINT8 *rom, UINT32 wsRomSize)
{
	ws_romHeaderStruct	*ws_romHeader;
	
	ws_rom=rom;
	romSize=wsRomSize;
	ws_romHeader=ws_rom_getHeader(ws_rom,romSize);
	ws_rom_checksum=ws_romHeader->checksum;
	internalRam=(UINT8*)malloc(0x10000);
	ws_staticRam=(UINT8*)malloc(0x10000); 
	externalEeprom=(UINT8*)malloc(131072);//ws_rom_eepromSize(ws_rom,romSize));
	sramAddressMask=ws_rom_sramSize(ws_rom,romSize)-1;
	externalEepromAddressMask=ws_rom_eepromSize(ws_rom,romSize)-1;
	internalEeprom = (UINT8*)malloc(INTERNAL_EEPRON_SIZE);

	romAddressMask=romSize-1;

	if (ws_romHeader->minimumSupportSystem==WS_SYSTEM_COLOR)
		ws_gpu_operatingInColor=1;

}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_memory_reset(void)
{
	memset((char*)internalRam,0,0x10000);
	memset((char*)ws_staticRam,0,0x10000);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_memory_done(void)
{
	free(ws_rom);
	free(ws_staticRam);
	free(internalRam);
	free(externalEeprom);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT8	*memory_getRom(void)
{
	return(ws_rom);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT32	memory_getRomSize(void)
{
	return(romSize);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT16	memory_getRomCrc(void)
{
	return(ws_rom_checksum);
}


void cpu_writemem20(UINT32 addr,UINT8 value)
{
	UINT32	offset=addr&0xffff;
	UINT32	bank=addr>>16;

	// 0 - RAM - 16 KB (WS) / 64 KB (WSC) internal RAM
	if (!bank)
	{
		ws_gpu_write_byte(offset,value);
		ws_audio_write_byte(offset,value);
	}
	else
	// 1 - SRAM (cart) 
	if (bank==1)
		ws_staticRam[offset&sramAddressMask]=value;

	// other banks are read-only
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT8 cpu_readmem20(UINT32 addr)
{
	UINT32	offset=addr&0xffff;
	UINT32	bank=addr>>16;
	
	switch (bank)
	{
	case 0:		// 0 - RAM - 16 KB (WS) / 64 KB (WSC) internal RAM
				if (ws_gpu_operatingInColor)
					return(internalRam[offset]);
				else
				if (offset<0x4000)
					return(internalRam[offset]);
				return(0xff);

	case 1:  	// 1 - SRAM (cart) 
				return ws_staticRam[offset&sramAddressMask];
	case 2:
	case 3:		return ws_rom[offset+((ws_ioRam[IO_ROM_BANK_BASE_SELECTOR+bank]&((romSize>>16)-1))<<16)];
	default: 
				int romBank=(256-(((ws_ioRam[IO_ROM_BANK_BASE_SELECTOR]&0xf)<<4)|(bank&0xf)));
				return ws_rom[(unsigned)(offset+romSize-(romBank<<16))];
	}
	return(0xff);
}
